module net.BurtonRadons.dedit.highlight.makefile;

import net.BurtonRadons.dedit.main;
import std.path;
import std.string;
import std.ctype;

alias std.ctype.isdigit isdigit;

/* Makefile highlighter. */
class Makefile_Highlighter : SyntaxHighlighter
{
    const char [] symbols = "()[]<>{}:;=!%^&*-+|/.~,$";

    this ()
    {
    }

    static this ()
    {
        list ~= new Makefile_Highlighter ();
    }

    override char [] name () { return "Makefile"; }
    override char [] exts () { return "makefile*"; }

    override float match (char [] filename, char [] [] data)
    {
        if (std.path.fnmatch (std.string.tolower (filename), "makefile*"))
            return 1;
        return 0;
    }

    TabParams tabParamsDefault ()
    {
        TabParams p = new TabParams ();

        p.indentSize = p.tabSize;
        p.keepTabs = true;
        p.useDefault = false;
        return p;
    }

    final bit isSymbol (char f)
    {
        for (int c; c < symbols.length; c ++)
            if (f == symbols [c])
                return true;

        return false;
    }
    
    struct LineInfo
    {
        char code; /**< Current highlighting code. */
        char open;
            /**< Current open type:
               * <ul>
               * <li>'*' - multiline comment.
               * <li>'"' - double-quoted std.string.
               * <li>"'" - single-quoted std.string.
               * <li>'i' - identifier.
               * <li>'/' - single-line comment.
               * <li>'#' - number.
               * </ul>
               */
    }

    override int extraSize () { return LineInfo.size; }

    override void highlight (char [] line, char [] high, void *lastp, void *nextp)
    {
        LineInfo *last = (LineInfo *) lastp;
        LineInfo *next = (LineInfo *) nextp;
        char *c, h, e;
        char code;
        char open;

        if (last !== null)
        {
            code = last.code;
            open = last.open;
        }
        code = 'i';

        char *start = line, hstart = high;

        c = line;
        h = high;
        e = c + line.length;

        while (c < e)
        {
            if (*c == '=')
            {
                c = line;
                while (c < e)
                {
                    if (*c == '=')
                    {             
                        start = c + 1;
                        hstart = h + 1;
                        break;
                    }

                    c ++;
                    *h ++ = 'm';
                }
                break;
            }

            if (!isalpha (*c) && !isalpha (*c))
                break;
            c ++;
        }

        c = start;
        h = hstart;

        while (c < e)
        {
            int n = (int) (e - c);
            char f = *c;
            char [] r;

        restart:
            if (open == '"')
            {
                if (c [0] == '\\')
                {
                    *h ++ = code;
                    c ++;
                    if (c < e)
                        goto def;
                    goto dun;
                }
                else if (c [0] == '"')
                {
                    *h ++ = code;
                    code = open = 0;
                    c ++;
                }
                else
                    goto def;
            }
            else if (open == '\'')
            {
                if (c [0] == '\\')
                {
                    *h ++ = code;
                    c ++;
                    if (c < e)
                        goto def;
                    goto dun;
                }
                else if (c [0] == '\'')
                {
                    *h ++ = code;
                    code = open = 0;
                    c ++;
                }
                else
                    goto def;
            }
            else if (open == '/')
                goto def;
        /* open == 0 from here on */
            else if (f == '#')
            {
                open = '/';
                code = '*';
                goto def;
            }
            else
            {
                if (isSymbol (f))
                {
                    *h ++ = 's';
                    c ++;
                }
                else
                    goto def;
            }

        dun:
            continue;
        def:
            *h ++ = code;
            c += 1;
        }

        if (open == 'i' || open == '/' || open == '#')
            open = 0;

        next.code = code;
        next.open = open;
    }
}
